unit MailTemplateSender;

{
  An e-mail sender for the mail template program.

  Copyright  Keith Wood (kbwood@iprimus.com.au)
  Version 1.0 - October 17 1999.
  Version 1.1 - April 25, 2000.
}

interface

uses
  SysUtils, Classes, NMSMTP, MailTemplateConst;

type
  TMailTemplateSender = class(TObject)
  private
    FSender: TNMSMTP;
  public
    constructor Create(Props: TStrings);
    destructor Destroy; override;
    procedure Send(FromEmail, ToEmail, SubjectLine, Message: string);
  end;

implementation

{ TMailTemplateSender ---------------------------------------------------------}

{ Initialisation }
constructor TMailTemplateSender.Create(Props: TStrings);
begin
  inherited Create;
  FSender := TNMSMTP.Create(nil);
  with FSender do
  begin
    Host := Props.Values[MailHostProp];
    try
      Port := StrToInt(Props.Values[MailPortProp]);
    except  { Ignore }
    end;
    UserId := Props.Values[MailUserProp];
    Connect;
  end;
end;

{ Release resources }
destructor TMailTemplateSender.Destroy;
begin
  FSender.Disconnect;
  FSender.Free;
  inherited Destroy;
end;

{ Send an e-mail }
procedure TMailTemplateSender.Send(FromEmail, ToEmail, SubjectLine, Message: string);
begin
  with FSender.PostMessage do
  begin
    FromAddress    := FromEmail;
    ToAddress.Text := ToEmail;
    Subject        := SubjectLine;
    Body.Text      := Message;
  end;
  FSender.SendMail;
end;

end.
